#ifndef _ExprArray_H
#define _ExprArray_H

#define MAX_EXPR_ARRAY_SIZE	 15




class ArgList;
class ExpressionDict;
class Expression;

/* If an arglist has as an array of values (ex., ad1, ad2, ad3, ad4...), this class
helps extract them and evaluate them easily.  */

class ExprArray {


	public:	
							ExprArray();
		virtual				~ExprArray();
		
		// Returns how many exrs are compiled/ready to be evaluated
		inline long			Count()	const								{ return mNumExprs;		}	
		
		// Adds the indentifiers and their corresponding addresses to the dict
		//void				LinkVars( long inID, ExpressionDict& ioDict );
		
		// Extracts a sequence of args from an arglist (ie., and array), and compiles them (with 
		// the given link dictionary).  If an arglist was known to contain ad1, ad2, ad3, ad4...,
		// we call: Compile( args, 'ad', theDict );
		// Post: Each identifier/element is added to ioDict.
		void				Compile( const ArgList& inArgs, long inID, ExpressionDict& ioDict );

		// Each loaded expression is evaluated and placed in mVals
		void				Evaluate();

		float				mVals[ MAX_EXPR_ARRAY_SIZE ];

	protected:
		Expression*			mExprs;
		long				mNumExprs;		
};


#endif

